/* $Id: screenfades.c,v 0.1 1999/08/08 18:34:06 wwwwolf Exp wwwwolf $

   Screen fade functions. These are cooler than the ones Yiff originally
   used. Why? Well, it's always nice to see screen fly off in an interesting
   way... and besides, these fades are FAST compared to the normal fade-off
   on XwinAllegro (that is mind-numbingly slow). Well, dunno if these are
   faster - they look cooler. =)
   
   Note: This is sometimes Heavy Wizardry, or at least it would look kind
   of confusing without the comments (*with* comments, these are utterly
   uninteresting because they're so obvious, and easy to code if you have
   tried to code some demo tricks... =)
   
   I wish to thank Jamie Zawinski, whose XScreenSaver hacs inspired me to do
   the "blindsweep" effect, among other things.
   
             - Weyfour WWWWolf


   *ahem* Now to the matter itself. But first, some general notes :
   
   The following parameters are used to clean the screen.
     *bitmap     Pointer to the bitmap to clear (screen, usually)
                 or from which we blit the stuff in crossfade.
     *to         The bitmap to which we blit our stuff.
     c           Color index to which to fade (0, usually, if that's black)
     xsize       Horizontal size of the bitmap to clean (640, usually)
     ysize       Vertical size of the bitmap to clean (480, usually)

   Also note that in normal fades, "bitmap" is being manipulated, and
   in crossfades "to" is being manipulated while "bitmap" stays as it is.
*/


#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <unistd.h>

#include "prototypes.h"

#ifdef SLOW_SWEEPS
#define MUNCHWAIT 20
#define SWEEPWAIT 50
#else
#define MUNCHWAIT 2
#define SWEEPWAIT 5
#endif



/*
  The Ancient Screen Clearing Hack from MIT's "HAKMEM" memo.
  The idea is simple: Screen is clobbered with the formula
  y = x XOR t.
  maxt parameter says the maximum t value. For 64x48 area to clean (with 10x10
  tiles, of course), I found 70 to be pretty good.
 */

void munch_clean(BITMAP *bitmap, int c, int maxt, int xsize, int ysize)
{
  int x,y,t;

  if(xsize % 10 != 0 || ysize % 10 != 0) {
    fprintf(stderr, "Error: Target size must be divisible by 10 (is %dx%d)\n",
	    xsize,ysize);
  }
  
  xsize /= 10; ysize /= 10;

  for(t=0; t<maxt; t++) {
    for(x=0; x <= xsize; x++) {
      y = (x)^(t); y %= ysize+1;
      rectfill(bitmap, x*10, y*10, x*10+10, y*10+10, c);
    }
    usleep(MUNCHWAIT);
  }
}

/*
  This is the same thing, but does a cross-fade.
 */

void munch_crossfade(BITMAP *bitmap, BITMAP *to, int c, int maxt,
		     int xsize, int ysize)
{
  int x,y,t;

  if(xsize % 10 != 0 || ysize % 10 != 0) {
    fprintf(stderr,
      "munch_crossfade: Target size must be divisible by 10 (is %dx%d)\n",
	    xsize, ysize);
    return;
  }
  
  xsize /= 10; ysize /= 10;

  if(c < 0) {
    /* Do direct crossfade */
    for(t=0; t<maxt; t++) {
      for(x=0; x <= xsize; x++) {
	y = (x)^(t); y %= ysize+1;
	blit(bitmap, to, x*10, y*10, x*10, y*10, 10, 10);
      }
      usleep(MUNCHWAIT);
    }
  } else {
    /* Fade via color - unimplemented (but would be easy to do) */
  }
  /* Make sure the whole image was blitted */
  blit(bitmap, to, 0,0 , 0,0 , xsize*10, ysize*10);
}


/*
  Does n33t gradual sweep (I call this a blind sweep).
  For idea source, see XScreenSaver.
 */

void blindsweep_clean(BITMAP *bitmap, int c, int xsize, int ysize)
{
  int y, n, w, a, b;

  ysize /= 10; /* We do this in steps of 10 anyway... */

  for(y=0; y < (ysize+4); y++) {
    for(n = y, w = 2; n >= 0 && w <= 10; n--, w += 2) {
      if(n < ysize) {
	a = (n*10)+(5-(w/2)); if(a<0) { a = 0; }
	b = (n*10)+(5+(w/2)); if(b<0) { b = 0; }
	rectfill(bitmap,0,a,xsize,b,c);
	usleep(SWEEPWAIT);
      }
    }
  }
}
