
#ifndef YIFF_PROTOTYPES_H
#define YIFF_PROTOTYPES_H

#include <allegro.h>

/* function prototypes */

/* yiff.c */

void fail(char *);              /* bad exit */
void cycle254(void);            /* interrupt routine to cycle colour 254 */
int  main(int, char **);        /* main function */
int  game(void);                /* play one game */
int  doplayer(int);             /* move player */
int  doyiffs(int);              /* perform yiffing */
int  screenx(int);              /* calculate tile->pixel screen X coordinate */
int  screeny(int);              /* same thing, but for Y coordinate */
void drawfox(int,int,int,int);  /* draw a fox on the grid, update counters */
void erasecell(int,int);        /* erase a grid cell with the background */
void display(void);             /* draw the screen */
void drawwall(int,int);         /* draw a wall in a grid */
void draw_sprites(void);        /* draw the sprites at the bottom */
void options(int *);            /* options window */
void title(void);               /* perform the title menu */
void charselectr(void);         /* player select */
void help(void);                /* help screen from menu */
void leave(void);               /* end the game, write the ini, say bye */

/* info.c */
void about(void);               /* about screen from menu */
void greet(void);               /* greet page from command line */


/* filenames.c - by WWWWolf */
char *datafilename(char *file); /* Get the name of a file in data dir... */
char *homefilename(char *file); /* ... or home directory. */

/* screenfades.c - by WWWWolf */

void munch_clean(BITMAP *bitmap, int c, int maxt, int xsize, int ysize);
                                /* Munching Squares screen sweep */
void munch_crossfade(BITMAP *bitmap, BITMAP *to, int c, int maxt,
		     int xsize, int ysize);
                                /* Munching Squares screen blit */
void blindsweep_clean(BITMAP *bitmap, int c, int xsize, int ysize);
                                /* Blinds screen sweep */


#endif /* YIFF_PROTOTYPES_H */
