
#ifndef YIFF_GLOBALS_H
#define YIFF_GLOBALS_H

#define TILEX 32        /* tile X pixel size */
#define TILEY 31        /* tile Y pixel size. No, they aren't square */
#define Xcells 6        /* number of cells across */
#define Ycells 4        /* number of cells down */
#define SETSPEED 1      /* speed control for animations */
#define DEFY 440        /* default Y position for sprites */
#define YIFFON 10       /* arbitrary number larger than 4 used to flag */
                        /* that a particular cell must YIFF */
#define OK 0            /* used in doplayer() */
#define RESTART 1       /* value to restart a game */
#define QUIT 2          /* value to quit a game */
#define S_P1_OFF 0      /* unused */
#define S_P2_OFF 8      /* used in charselectr(), offset to the player 2 */
                        /* colors of the sprites */
#define S_SAM_OFF 16    /* offset to audio data in charselectr() data */

/**/

/* global variables - nearly all variables are global */

DATAFILE *data;                         /* main data file */
DATAFILE *character0,*character1;       /* character data files */
FILE *fp;                               /* generic file pointer */
char charanim[2][50];                   /* player sprite animation strings */
char charyoff[2][50];                   /* y offset strings for animation */
char playname[2][10];                   /* name of each player */
int charpitch[2];                       /* audio playback rate for player */
int deady[2];                           /* y co-ordinate for 'dead' sprite */
int charx[2],chary[2];                  /* current X and Y positions */
int chars[2];                           /* current sprite number */
int xoff=16, yoff=0;                    /* screen offset for tile drawing */
int x,y,z,drfl,tx,ty;                   /* mostly generic */
int cycle_red,cycle_blue,cycle_dir;     /* used in color cycling routine */
int black,white,nosound;                /* color index for black, white */
                                        /* flag for disabled sound */
RGB col;                                /* generic color variable */
int score[3],walls[3],grid[Xcells][Ycells]; /* current score, current walls */
                                            /* set to 3 for ease of use (1,2) */
                                            /* grid information */
int iloaded;                            /* interrupt loaded flag */
int max[Xcells][Ycells]={{2,3,3,2}, {3,4,4,3},  /* max counters for grid */
	{3,4,4,3}, {3,4,4,3}, {3,4,4,3}, {2,3,3,2}};  /* this sets the YIFF limits */
int plgrid[3][Xcells][Ycells];          /* individual player counts (0 unused) */
int animspeed;                          /* used for animation timing */
int players;                            /* number of players (0-2) */
int MIDIvol,DIGIvol,i;                  /* volume settings, generic counter */
int charp0,charp1;                      /* character # for each player */
                                        /* 0 = Yiff Li, etc */
int *intp;                              /* used to load from INI file */
char string[80];                        /* temp string */
BITMAP *background,*work,*picture;      /* background image space (grid), */
                                        /* work space (mixer) */
                                        /* picture space (far background) */

#endif /* YIFF_GLOBALS_H */
