/*********************************************************************
 * Yiff!
 * Filename-related stuff.
 * $Id: filenames.c,v 0.0 1999/04/26 21:38:15 wwwwolf Exp wwwwolf $
 */

#include <stdlib.h>     /* getenv() */
#include <unistd.h>     /* getuid(), access() */
#include <pwd.h>        /* getpwuid() */
#include <sys/types.h>  /* getpwuid(), getuid() */
#include <string.h>     /* strcmp(), strcpy(), strcat() */

#include "prototypes.h"
#include "path_resolver.h"

char Result[32768];

char *datafilename(char *file)
{
#ifndef UNIX /* We're in DOS and want our filenames au naturel. */
  strcpy(Result,file);
#else /* We're under UNIX, we want to be interesting... */

  char *checkthese[] = {
    "/usr/local/games/lib/yiff",
    "/usr/games/lib/yiff",
    "/usr/local/lib/games/yiff",
    "/usr/lib/games/yiff",
    "/usr/local/lib/yiff",
    "/usr/lib/yiff"
  };
  
  strcpy(Result,resolve_data_path(file, checkthese));

  if(access(Result, R_OK) != 0) {
    /* Not found from any library dir or wd */
    if(getenv("YIFF_GAMELIB") != NULL) {
      /* We have this environment variable set */
      strcpy(Result, getenv("YIFF_GAMELIB"));
      strcat(Result, "/");
      strcat(Result, file);
      if(access(Result, R_OK) != 0) {
	/* Damn, we still don't have any clue... let's just give up
	   and assume it's in current directory. Well, we don't have
	   it in wd (as proved above), so Yiff will just whine.
	*/
	strcpy(Result,file);
      }
    }
  }

#endif /* Either way, we return the results now. */

  return Result;
}

char *homefilename(char *file)
{
#ifndef UNIX /* Again to the DOS we will go... */
  strcpy(Result,file);
#else /* nope! We do the interesting stuff if we're in UNIX. */
  if(strcmp(getenv("HOME"),"") == 0) {
    /* Ack, we have no HOME env.variable */
    if(strcmp(getpwuid(getuid())->pw_dir, "") != 0) {
      strcpy(Result, getpwuid(getuid())->pw_dir);
    } else {
      fail("You're homeless! Set $HOME to point to your home directory.");
    }
  } else {
    /* Yes, we know where our HOME is */
    strcpy(Result,getenv("HOME"));
  }
  strcat(Result,"/");
  strcat(Result,file);
#endif
  return Result;
}
