/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

/* GTK+ interface; huge thanks to the GTK+ team for such a nice toolkit. :) */
/* http://library.gnome.org/devel/gtk/stable/
 * http://library.gnome.org/devel/glib/stable/
 * http://library.gnome.org/devel/libglade/stable/GladeXML.html
 * http://library.gnome.org/devel/gdk-pixbuf/stable/ */

#include <stdlib.h>
#include <stdint.h>

#include <gtk/gtk.h>

#include "gtkloader.h"
#include "gtksetup.h"
#include "gtkgrid.h"
#include "game.h"

typedef struct {
	/* The game being played (not const; may abort) */
	fcgame* game;
	/* All information on how the game was configured; also needed to give
	 * AIs their state back. This is sort-of-const, but AIs may modify their
	 * state, and AI players may be unceremoniously renamed if broken. */
	setupinfo* gamesetup;
	/* Player currently playing */
	uint8_t playing;
} playinfo;

static GtkWidget* gamewin;

/** Misc. rendering ***********************************************************/

static void message_box(GtkMessageType type, const char* message) {
	GtkWidget* dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW(gamewin),
		GTK_DIALOG_DESTROY_WITH_PARENT, type, GTK_BUTTONS_OK, message);
	if(dialog) {
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(GTK_WIDGET(dialog));
	} else {
		g_critical("Not enough memory for dialogue box for message:");
		g_critical(message);
	}
}

/** Playing the game (inc. callbacks) *****************************************/
static void cb_place(void* data, uint8_t player, uint8_t* x, uint8_t* y) {
	//playinfo* play = (playinfo*) data;

	/* TODO get a placement */
}

static void cb_placed(void* data, uint8_t player, uint8_t x, uint8_t y) {
	/* Redraw player list and this cell */
}

static void cb_invalid(void* data, uint8_t player, uint8_t x, uint8_t y) {
	//playinfo* play = (playinfo*) data;
	/* if(play->gamesetup->player_ai[play->playing]) {
		draw_popup(play, player, "has gone wrong and is being replaced with a human", true);
		strcpy(play->gamesetup->player_name[play->playing], "Broken");
		play->gamesetup->ai_jumps[player].broken
			(play->gamesetup->ai_state[player]);
		play->gamesetup->player_ai[player] = false;
	} else {
		draw_popup(play, player, "can only place atoms on empty or self-owned squares", true);
	} */
}

static void cb_full(void* data, uint8_t player, uint8_t x, uint8_t y) {}

static void cb_explode(void* data, const fcexplosion* explosion) {
	/* draw_explosion((playinfo*) data, explosion); */
}

static void cb_eliminated(void* data, uint8_t player) {
	//playinfo* play = (playinfo*) data;

	/* draw_popup(play, player, "is out of the game!", false);
	if(play->gamesetup->player_ai[player]) {
		play->gamesetup->ai_jumps[player].lost
			(play->gamesetup->ai_state[player]);
	} */
}

static void cb_wins(void* data, uint8_t player) {
	//playinfo* play = (playinfo*) data;

	/* draw_popup(play, player, "has won the game!", true);
	if(play->gamesetup->player_ai[player]) {
		play->gamesetup->ai_jumps[player].won
			(play->gamesetup->ai_state[player]);
	} */
}

static void fb_say(void* data, const char* phrase) {
	/* AI code only runs during the AI's turn, so they must be the current
	 * player. */
	//playinfo* play = (playinfo*) data;
	/* TODO Pop up a dialogue */
}

static void fb_hlcell(void* data, uint8_t x, uint8_t y, int16_t value) {
	/* TODO Draw the values somewhere */
}

static void fb_hlapply(void* data) {
	/* TODO Possibly a no-op? */
}

static void play_game(setupinfo* gamesetup) {
	fcgame game;
	fccallbacks callbacks;
	uifeedback feedback;
	playinfo play;
	
	/* Initialise callback data */
	play.game = &game;
	play.gamesetup = gamesetup;
	play.playing = 0;

	callbacks.data = &play;
	callbacks.place      = cb_place;
	callbacks.placed     = cb_placed;
	callbacks.invalid    = cb_invalid;
	callbacks.full       = cb_full;
	callbacks.explode    = cb_explode;
	callbacks.eliminated = cb_eliminated;
	callbacks.wins       = cb_wins;

	feedback.data = &play;
	feedback.say     = fb_say;
	feedback.hlcell  = fb_hlcell;
	feedback.hlapply = fb_hlapply;

	/* Run the game */
	if(game_init(&game, gamesetup->width, gamesetup->height,
		gamesetup->players, &callbacks)) {

		/* TODO */
		game_abort(&game);
	} else {
		message_box(GTK_MESSAGE_ERROR, "Can't create game (out of memory?)");
	}
}

/** Startup *******************************************************************/

int main(int argc, char** argv) {
	GtkTable* gridwidget;
	gamegrid grid;

	gtk_init(&argc, &argv);

	gamewin = load_game_window();
	if(!gamewin) {
		g_critical("Can't find the game window.");
		return 1;
	}
	g_signal_connect(gamewin, "delete-event",
		G_CALLBACK(gtk_main_quit), NULL);
	g_signal_connect(gamewin, "destroy",
		G_CALLBACK(gtk_main_quit), NULL);

	gridwidget = load_game_grid();
	if(!gridwidget) {
		g_critical("Can't find the game grid.");
		return 1;
	}
	gamegrid_setup(&grid, gridwidget);

	/* We need to do this on behalf of the AI, as we are the entry point. */
	srand(time(0));

	/* TODO Debug; should start whole new game with some sensible
	 * defaults here (much like ncurses). g_get_real_name() */
	GdkColor debug_orange = { 0xffaa00ff, 0xffff, 0xaaaa, 0x0000 };
	GdkColor debug_green  = { 0x00ff00ff, 0x0000, 0xffff, 0x0000 };
	setupinfo debug_setup;
	setupinfo_init(&debug_setup, 11, 7, 2);
	debug_setup.player_info[0] = setupinfoplayer_new(g_get_real_name(),
		"circular", debug_orange);
	debug_setup.player_info[1] = setupinfoplayer_new("Captain Facts",
		"circular", debug_green);

	play_game(&debug_setup);

	setupinfo_deinit(&debug_setup);

	/* gamegrid_reset(&grid, 11, 7);
	gamegrid_setcell(&grid, 3, 2,
		load_colour_atom("circular", &debug_orange, 3, 32, 32));
	gamegrid_setcell(&grid, 5, 4,
		load_colour_atom("circular", &debug_green, 0, 32, 32)); */

	gtk_widget_show(gamewin);
	gtk_main();

	return 0;
}

/* Open/save of game states would be nice. */
/* 'Computer player' checkbox should ultimately be replaced with dropdown
 * containing 'human' and the AIs from the factory. */

