/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

#ifndef GTK_SETUP_H_
#define GTK_SETUP_H_

#include <stdint.h>
#include <stdbool.h>
#include <gtk/gtk.h>

#include "ai.h"

typedef struct {
	/* Player name */
	char* name;
	/* Name of shape */
	char* shape;
	/* Player colour (spelt incorrectly as per GDK) */
	GdkColor color;
	/* Is AI? If so, jump table and state */
	bool ai;
	aijumps ai_jumps;
	aistate ai_state;
} setupinfoplayer;

/* Duplicates strings; returns null on fail */
setupinfoplayer* setupinfoplayer_new(const char* name,	const char* shape,
	GdkColor color);

setupinfoplayer* setupinfoplayer_new_ai(const char* name, const char* shape,
	GdkColor color, aijumps jumps, aistate state);

/* Doesn't free AI; that is done via win/lose/abort callback before */
void setupinfoplayer_destroy(setupinfoplayer* self);

typedef struct {
	/* Desired grid size */
	uint8_t width, height;
	/* Number of players, including AIs */
	uint8_t players;
	/* Array of heap-allocated player informations */
	setupinfoplayer** player_info;
} setupinfo;

/* Init with space for given number of players; true on success */
bool setupinfo_init(setupinfo* self, uint8_t width, uint8_t height,
	uint8_t players);

/* Zaps all the setupinfoplayers */
void setupinfo_deinit(setupinfo* self);

#endif

