/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

/* Look, seriously C99, don't take away my damn non-'n' string.h functions.
 * I'm duplicating strings ultimately provided by trustworthy GTK+, damnit. */
#define _BSD_SOURCE
#include <stdlib.h>
#include <string.h>

#include "gtksetup.h"

/* NB: Having these heap-allocatable will probably be useful when throwing
 * them around in the game setup window, which is going to need custom
 * tree model/view shenanigans */
setupinfoplayer* setupinfoplayer_new(const char* name, const char* shape,
	GdkColor color) {

	setupinfoplayer* self = malloc(sizeof(setupinfoplayer));
	if(!self) { return 0; }
	self->name  = strdup(name);
	self->shape = strdup(shape);
	self->color = color;
	self->ai = false;
	if(self->name && self->shape) {
		return self;
	} else {
		if(self->name)  { free(self->name);  }
		if(self->shape) { free(self->shape); }
		free(self);
		return 0;
	}
}

setupinfoplayer* setupinfoplayer_new_ai(const char* name, const char* shape,
	GdkColor color, aijumps jumps, aistate state) {

	setupinfoplayer* self = setupinfoplayer_new(name, shape, color);
	if(!self) { return 0; }
	self->ai = true;
	self->ai_jumps = jumps;
	self->ai_state = state;
	return self;
}

void setupinfoplayer_destroy(setupinfoplayer* self) {
	free(self->name);
	free(self->shape);
	free(self);
}


bool setupinfo_init(setupinfo* self, uint8_t width, uint8_t height,
	uint8_t players) {

	self->player_info = malloc(sizeof(setupinfoplayer*) * players);
	if(!self->player_info) { return false; }

	self->width   = width;
	self->height  = height;
	self->players = players;
	return true;
}

void setupinfo_deinit(setupinfo* self) {
	for(int i = 0; i < self->players; i++) {
		setupinfoplayer_destroy(self->player_info[i]);
	}
	free(self->player_info);
}

