/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

#include "gtkplayer.h"
#include "gtkloader.h"

void playersettings_init(playersettings* ps,
	const gchar* shape, const GdkColor* colour, const gchar* name) {

	ps->shape = g_strdup(shape);
	ps->name  = g_strdup(name);
	ps->colour.pixel = colour->pixel;
	ps->colour.red   = colour->red;
	ps->colour.green = colour->green;
	ps->colour.blue  = colour->blue;
	for(int i = 0; i < 5; i++) { ps->atompix[i] = 0; }
}

void playersettings_loadatoms(playersettings* ps, int width, int height) {
	for(int atoms = 0; atoms < 5; atoms++) {
		if(ps->atompix[atoms])
			{ g_object_unref(ps->atompix[atoms]); }
		ps->atompix[atoms] = load_colour_atom(ps->shape, &ps->colour,
			atoms, width, height);
	}
}

void playersettings_free(playersettings* ps) {
	g_free(ps->shape);
	g_free(ps->name);
	for(int i = 0; i < 5; i++) { g_object_unref(ps->atompix[i]); }
}

