/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

/* Pseudo-widget which latches onto a GtkTable and turns it into a grid of
 * buttons with pretty pictures on. */

#ifndef GTKGRID_H_
#define GTKGRID_H_

#include <stdint.h>

#include <gtk/gtk.h>

typedef struct {
	GtkTable* table;
	uint8_t width;
	uint8_t height;
	/* Need to keep buttons around for random-access changes to them */
	GtkWidget* buttons[256][256];
} gamegrid;

/* Latch a gamegrid onto a GtkTable. */
void gamegrid_setup(gamegrid* grid, GtkTable* table);

/* Set up the grid for a new game. */
void gamegrid_reset(gamegrid* grid, uint8_t width, uint8_t height);

/* Set a cell of the grid to a given image, or NULL for empty cell. */
void gamegrid_setcell(gamegrid* grid, uint8_t x, uint8_t y, GdkPixbuf* pb);

#endif

