/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

#include "gtkgrid.h"

void gamegrid_setup(gamegrid* grid, GtkTable* table) {
	grid->table = table;
	grid->width = 0;
	grid->height = 0;
	/* Zero this for ease of debugging */
	for(uint16_t y = 0; y < 256; y++) {
		for(uint16_t x = 0; x < 256; x++) {
			grid->buttons[x][y] = 0;
		}
	}
}

static void gamegrid_reset_destroy(GtkWidget* widget, gpointer ignored) {
	gtk_widget_destroy(widget);
}
void gamegrid_reset(gamegrid* grid, uint8_t width, uint8_t height) {
	grid->width  = width;
	grid->height = height;
	gtk_container_foreach(GTK_CONTAINER(grid->table),
		gamegrid_reset_destroy, 0);
	gtk_table_resize(grid->table, height, width);
	for(uint8_t y = 0; y < height; y++) {
		for(uint8_t x = 0; x < width; x++) {
			GtkWidget* button = gtk_button_new();
			grid->buttons[x][y] = button;
			gtk_widget_set_size_request(button, 16, 16);
			gtk_table_attach_defaults(grid->table, button,
				x, x + 1, y, y + 1);
			gtk_button_set_image(GTK_BUTTON(button),
				gtk_image_new());
			gtk_widget_show(button);
		}
	}
	/* g_signal_connect(button, "size-allocate",
		G_CALLBACK(resize_handling_callback), NULL); */
}
/* static void gamegrid_resize(GtkWidget* widget, GtkAllocation* alloc, gpointer shutuppea) {
	printf("%d x %d\n", alloc->width, alloc->height);
} */

void gamegrid_setcell(gamegrid* grid, uint8_t x, uint8_t y, GdkPixbuf* pb) {
	GtkImage* image = GTK_IMAGE(gtk_button_get_image(
		GTK_BUTTON(grid->buttons[x][y])));
	if(pb) {
		gtk_image_set_from_pixbuf(image, pb);
	} else {
		gtk_image_clear(GTK_IMAGE(image));
	}
}

