/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

#ifndef UI_H_
#define UI_H_

/* Generally, UIs have free reign as to how they behave---they are the entry
 * point, and they construct and run games and AIs as they see fit. The only
 * constraints are:
 *  - they must call srand() to initialise the RNG for the AIs
 *  - they should provide a uifeedback structure to the AIs
 * See the ncurses UI for an example.
 */

/* Callbacks for the AI to display things on the UI, generally for debugging.
 * These are not allowed to be NULL, but they may be no-ops. */
typedef struct {
	/* Data pointer to be passed as the first argument of each callback.
	 * Don't mess with this unless you enjoy segmentation faults. */
	void* data;
	/* Display a string of text. This might go to a buffered log window,
	 * for example, although ncurses uses a pop-up. Don't spam with it. */
	void (*say)(void* data, const char* phrase);
	/* Highlight a cell with a value. Call this multiple times, then use
	 * hlapply to 'set' the highlights for a moment. A value of zero means
	 * that the cell should be undecorated, otherwise the value ranges from
	 * -255 to 255 (values beyond this shall be clipped). */
	void (*hlcell)(void* data, uint8_t x, uint8_t y, int16_t value);
	/* Show the highlights which have been set for a second or two, then
	 * continue. */
	void (*hlapply)(void* data);
} uifeedback;

#endif

