/* FreeChain - A cross-UI, cross-platform, Free version of Chain Reaction     *
 * Copyright 2007 Philip Boulain. Licenced under the GNU GPL.                 */

#ifndef NCURSESUI_H_
#define NCURSESUI_H_

/* ncurses interface; huge thanks to the people behind this fine documentation:
 * http://tldp.org/HOWTO/NCURSES-Programming-HOWTO/ */

#include "game.h"
#include "ai.h"

#define COLPLAY(x) ((x)+1)

typedef struct {
	/* Desired grid size */
	uint8_t width, height;
	/* Number of players, including AIs */
	uint8_t players;
	/* Player number; (null-terminated) string */
	char player_name[6][16];
	/* Player colours: map to COLPLAY macro.
	 * Allows player IDs to be consecutive from zero, as game expects,
	 * while allowing non-consecutive colours. Should still have no dups.
	 * In the interests of minimal mindbending, spelt incorrectly. */
	uint8_t player_color[6];
	/* AI flags; jump table and states if so */
	bool player_ai[6];
	aijumps ai_jumps[6];
	aistate ai_state[6];
} setupinfo;

/* Switch to the menu and prompt for players, etc. Returns true to start game,
 * false to quit. Switches out of the menu before returning. */
bool setup_game(setupinfo* gamesetup);

#endif

