/* Workarounds for limitations of current DJGPP/PDCURSES environment. */
/* Also: manual declaration of delay from dos.h in ncurses.c due to DJGPP
   headers not exposing it to suitably pedantic C99 programs, but need for it
   as usleep is likewise constrained and nanosleep isn't available. */
/* Also: use of pstdint.h as DJGPP currently omits this, and patching of it
   to still declare basic types even though this is C99 and recent GCC. */

#ifndef MSDOS
 #error This header should only be used conditionally for MS-DOS
#endif

inline static void snprintf(char* buffer, size_t IGNORED, const char* format, ...) {
        va_list argp;
        va_start(argp, format);
        vsprintf(buffer, format, argp);
        va_end(argp);
}

inline static char* getlogin(void) {
        return "Player";
}

